function omformat(n){ //format number n with p positions
	     if(Math.abs(n) < 0.001  ){ return (1000000 * n).toPrecision(3) + "\u03BC"; }
	else if(Math.abs(n) < 1      ){ return (1000 * n).toPrecision(3)    + "m"; }
	else if(Math.abs(n) < 1000   ){ return (n).toPrecision(3)           + "" ; }
	else if(Math.abs(n) < 1000000){ return (n / 1000).toPrecision(3)    + "k"; }
	else return (Math.abs(n) / 1000000).toPrecision(3) + "M";
}

function getmean(arr,min,step){
	var res = 0, total = 0;
	for(var i = min; i < arr.length; i+=step){
		res += arr[i] * i;
		total += arr[i] * 1;
	}
	return res / total;
}

function min(arr){
	var res = arr[0];
	for(var i = 0; i < arr.length; i++){ if(arr[i] < res) res = arr[i]; }
	return res;
}

function max(arr){
	var res = arr[0]
	for(var i = 0; i < arr.length; i++){ if(arr[i] > res) res = arr[i]; }
	return res;
}

function getstdev(arr,min,step){
	var res = 0, mean = getmean(arr,min), total = 0;
	for(var i = min; i < arr.length; i+=step) total += arr[i];
	for(var i = min; i < arr.length; i+=step) res += (arr[i]/total) * Math.pow(i - mean,2);
	return Math.sqrt(res);
}

function pad(num,pos){ //append zeros in front of or after decimal numbers 'num  with 'pos' required digits
	if(pos <= Math.ceil(Math.log(num)/Math.LN10)) return "" + Math.round(num);
	else if(num < 1) return (num + Array(pos).join("0")).slice(0,pos);
	else return (num + Array(pos).join("0")).slice(0,pos);
}

function generateColor(grad){ //generate a #xxxxxx color based on grayscale number between 0-1
	var idx = Math.floor(255 * grad), H = Math.floor(idx / 16), L = idx % 16;
	var result = hex[H] + hex[L]; 
	return "#" + result + result + result;
}

//got this from stackoverflow
function wndsize(){
	var w = 0;var h = 0;
	//IE
	if(!window.innerWidth){
		if(!(document.documentElement.clientWidth == 0)){			
			w = document.documentElement.clientWidth;h = document.documentElement.clientHeight; //strict mode
		} else {			
			w = document.body.clientWidth;h = document.body.clientHeight; //quirks mode
		}
	} else {		
		w = window.innerWidth;h = window.innerHeight; //w3c
	}
	return Array(w,h);
}

//Juan Mendes, stackoverflow
function roundRect(ctx, x, y, width, height, radius, fill, stroke) {
  if (typeof stroke == "undefined" ) {
    stroke = true;
  }
  if (typeof radius === "undefined") {
    radius = 5;
  }
  ctx.beginPath();
  ctx.moveTo(x + radius, y);
  ctx.lineTo(x + width - radius, y);
  ctx.quadraticCurveTo(x + width, y, x + width, y + radius);
  ctx.lineTo(x + width, y + height - radius);
  ctx.quadraticCurveTo(x + width, y + height, x + width - radius, y + height);
  ctx.lineTo(x + radius, y + height);
  ctx.quadraticCurveTo(x, y + height, x, y + height - radius);
  ctx.lineTo(x, y + radius);
  ctx.quadraticCurveTo(x, y, x + radius, y);
  ctx.closePath();
  if (stroke) {
    ctx.stroke();
  }
  if (fill) {
    ctx.fill();
  }        
}

function swap(val) {
    return ((val & 0xFF) << 8)
           | ((val >> 8) & 0xFF);
}

function error(msg, callback, callbackmsg){
	document.getElementById("errordiv").style.display = "inline";	
	document.getElementById("errormsg").innerText = msg;
	document.getElementById("errorbtn").onclick = function(){
														document.getElementById("errordiv").style.display = "none";
														callback()
													};
	document.getElementById("errorbtn").value = callbackmsg;
}

function arrayAverage(arr, min){
	var res = 0;
	for(var i = min; i < arr.length; i++){
		res += arr[i];
	}
	return res / (arr.length - min);
}

function dump(){
	if(fast_data[0][1] > 65536){
		return fast_data[0][2].slice(-65536).join(" ");
	}
}

//produces a hex string from an array of 8-bit values
var __hex = ["0","1","2","3","4","5","6","7","8","9","A","B","C","D","E","F"];
function toHex(arr){
	var res = "";
	for(var i = 0; i < arr.length; i++){
		res += __hex[Math.floor(arr[i] / 16)] + __hex[arr[i] % 16];
	}
	return res;
}

Number.prototype.mod = function(n) { return ((this%n)+n)%n; }