var fft_n = 65536, fft_n2 = 2 * fft_n; //input array length, should be 2^n with n=integer
g = 16;	//number of bits
var tmp_arr = new Array(fft_n2);

var dftarray = new Array();
var bitrevarray = new Array();
var halfsinarray = new Array();
var sinarray = new Array();

//test input array
for(var i = 0; i < fft_n; i++) dftarray[i] = (i / 10) % 1 + 0.5;

//pre-computed n+1-bit bit reversal array
for(var i = 0; i < fft_n2; i++){ var bitrevi = 0, j = 0; while(j < (g + 1)){bitrevi += (i & (1 << j)) ? 1 << (g - j) : 0; j++;}	bitrevarray[i] = bitrevi;}

//pre-computed sine array
for(var i = 2; i < fft_n2 + 1; i <<= 1){
	halfsinarray[i] = Math.sin(2 * Math.PI / i);
	sinarray[i] = Math.sin(Math.PI / i);
}


function fft(arr)	{	//performs an FFT on a fixed 65536-sample array
	//put arr into tmp_arr using bit reversal method using precomputed bit reversal array
	for(var i = 0, j = 0; i < fft_n2; i += 2, j++){	
		tmp_arr[bitrevarray[i]] = arr[j];
		tmp_arr[bitrevarray[i + 1]] = 0;
	}
	
	//Danielson-Lanzcos
    var mmax = 2;

    while (fft_n2 > mmax)
    {
        istep 	= mmax << 1;
        wtemp 	= halfsinarray[mmax];
        wpr 	= -2 * wtemp * wtemp;
        wpi		= sinarray[mmax];
        wr		= 1;
        wi		= 0;
        
        for (m = 1; m < mmax; m += 2) {
            for (i = m; i <= fft_n; i += istep) {
                j		  	  = i + mmax;
                tempr	  	  = wr * tmp_arr[j - 1] - wi * tmp_arr[j];
                tempi	  	  = wr * tmp_arr[j]	    + wi * tmp_arr[j-1];
                tmp_arr[j-1]  =      tmp_arr[i - 1] - tempr;
                tmp_arr[j]	  =      tmp_arr[i]     - tempi;
                tmp_arr[i-1] += tempr;
                tmp_arr[i]   += tempi;
            }
			wtemp = wr;
            wr = wtemp * wpr - wi * wpi + wr;
            wi = wi * wpr + wtemp * wpi + wi;
        }
        mmax = istep;
    }
	
	for(i = 0, j = 0; i < fft_n; i++, j += 2){
		tmp_arr[i] = Math.sqrt(tmp_arr[j] * tmp_arr[j] + tmp_arr[j + 1] * tmp_arr[j + 1]) * 2 ;
	}
	
	tmp_arr[0] = tmp_arr[2];
	tmp_arr[1] = tmp_arr[2];
	return tmp_arr.slice(0,fft_n / 2);
}
