_boardConfig = {
    "sensorBoards": [
		{ 
			"boardName": "USB sensor",
			"channels": [
				{ //0
					"type": "I",
					"unit": "A",
					"gain": 0.5,		//V/A
					"reference": 3.3,	//ADC ref voltage
					"resolution": 4096, //ADC max counts
					"zeropoint": 2048,		//ADC counts corresponding to 0V
					"use_voltage": 1,   //use voltage from channel 1 for power calculations
					"name": "I5V"
				},
				{ //1
					"type": "U",
					"unit": "V",
					"gain": 0.10405,
					"resolution": 4096,
					"zeropoint": 2048,
					"name": "5Vin",
					"reference": 3.3/1.6
				}
			],
			"calibration": { 
				"reference": [0, 0.01, 0.1, 0.2, 0.5, 1, 2, 3, 20],
				"I5V":  [1, 10,	100,  200,	500, 1000,  2000,	3000,  20000]
			}
		}
	],
	"interfaceBoards": [
		{  //board 0
			"boardName" : "USB sensor",
			"FFname" : "usb sensor rev3 \n", //response to '0xFF' (presence detect) command
			"timebase": 0.001, //seconds per sample
			"channelAssignment": [ //position of sensor board (right argument) channels on interface board channels (left argument). -1 = not installed
			0, //0
			-1, //1
			-1, //2
			-1,  //3
			-1,  //4
			-1,
			-1,
			-1,
			-1,
			-1,
			1,
			-1,
			-1,
			-1,
			-1,
			-1,
			-1//16
			]
		}
	],

	"powersupplies":[
		{ //psu 0
			"psuName": "Seasonic G450 Modular",
			"voltages" :{
				"ATX12V": 12.25,
				"12V": 12.25,
				"12Vsb": 12.25,
				"5Vsb": 5.03,
				"5V": 5.016,
				"3V3": 3.363 
			}
		},
		{ //psu 1
			"psuName": "be quiet! SFX 300W",
			"voltages" :{
				"ATX12V": 11.82,
				"12V": 11.82,
				"5Vsb": 5.11,
				"5V": 5.11,
				"3V3": 3.378 
			}
		},
		{ //psu 2
			"psuName": "19V adapter Fluffy",
			"voltages" :{
				"I19V": 18.75
			}		
		},
		{ //psu 3
			"psuName": "Floppy2 12V",
			"voltages" :{
				"12Vin": 12,
				"12Vbat": 12
			}
		},
		{ //psu 3
			"psuName": "USB 5V",
			"voltages" :{
				"I5V": 5
			}
		}
	],
	
	"addresses":[
		{
			"address":"ws://localhost:5331",
			"name":"localhost (port 5331)"
		},
		{
			"address":"ws://195.222.116.169:5331",
			"name":"Emile Nijssen (Berkel)"
		},
		{
			"address":"ws://floppy2:5331",
			"name":"Floppy2"
		},
		{
			"address":"ws://192.168.0.103:5331",
			"name":"SEFLab test"
		},
		{
			"address":"ws://145.92.135.68:5331",
			"name":"SEFLab extern"
		}
	]
}